#!/bin/bash -xv

HomeDir=`dirname $0`

. $HomeDir/local.conf

if [ "$1" == "test" ]; then
        echo "Version 5.33 (kvm, img, ZFS)"
	echo "Limit from ${BwLimit[1]} to ${BwLimit[2]} is ${BwLimit[3]}, after is ${BwLimit[0]}."
	exit
fi

mkdir $TmpDir
mkdir $HomeDir/mnt
mkdir $HomeDir/emptydir
mkdir -p $BackupTo/removed/$Today

d1=`date`

if [ -f $PID ]; then
        CURPID=`/bin/cat $PID`
        if [ `/bin/ps ax | grep $CURPID | grep -c 'bsys'` -gt 0 ]; then
                echo "Another copy of this program working now with pid = $CURPID"
                echo "[ $d1 ] Another copy of this program working now with pid = $CURPID" >> $Log
                exit 0
        fi
fi

echo $$ > $PID

echo "Version 5.33 (kvm, img, ZFS)"

Opts="--force --ignore-errors --delete-excluded --delete -a --backup --backup-dir=$BackupTo"

Cpuwatch=$HomeDir/cpuwatch_`arch`

export PATH=$PATH:/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin

message=''

i=1
while [ `df -P | grep $MountPoint$ | wc -l` -lt 1 ]
do
        if [ $i -eq 0 ]; then
                echo "Can't mount $DeviceName to $MountPoint [`date '+%F %T'`]" >> $Log
                echo "Start backup, Day - $Today, CMD - /bin/mount -o rw $DeviceName $MountPoint" | mail -s "Can't mount $MountPoint on `hostname` [`date '+%F %T'`]" $Mail
                exit
        fi
	let "i = $i - 1"
done

uuid=`/bin/cat /proc/sys/kernel/random/uuid`
echo $uuid > $BackupTo/uuid
if [ "$uuid" != "`/bin/cat $BackupTo/uuid`" ]; then
	echo "Can't write to $DeviceName [`date '+%F %T'`]" >> $Log
	echo "Start backup, Day - $Today" | mail -s "Can't write to $DeviceName on `hostname` [`date '+%F %T'`]" $Mail
        exit
fi

echo "-------------BEGIN $d1--------------------" >> $Log
date_begin=`date '+%F %T'`
echo "$date_begin" > $LocalStatus
echo "0" >> $LocalStatus
echo "$Today" >> $LocalStatus
scp -i $HomeDir/.ssh/rstats $LocalStatus serverstats@91.239.235.70:/home/backup_stats/local/`hostname`
echo -n "" > $HomeDir/TheEnd.tmp

if [ `mount | grep $HomeDir/mnt | wc -l` -gt 0 ]; then
        umount $HomeDir/mnt
fi

for loop in `losetup -a | tr -d '()' | awk '{print $3}'`
do
	echo "DETACH $loop"
	for lvmapmirror in `kpartx -l $loop | awk '{print $1}'`
	do
		umount /dev/mapper/$lvmapmirror
	done
	kpartx -d $loop
done

for vol in `zfs list -H -o name | grep '_snapshot'`
do
        echo "REMOVE $vol"
	kpartx -d /dev/zvol/$vol
	lv=`basename $vol`
	lvsnap=`echo ${lv} | sed 's/-/--/g'`
	if [ `dmsetup ls | grep "$lvsnap"[1-9] | wc -l` -ge 1 ]; then
		dmsetup ls | grep "$lvsnap"[1-9] | awk '{print $1}' | xargs -i dmsetup remove {}
	fi
	zfs destroy $vol
done

for vol in `zfs list -H -o name -t snapshot | grep '@snapshot'`
do
	zfs destroy $vol
done

$Cpuwatch $Avg nice --adjustment=+15 /usr/bin/rsync --delete -a $HomeDir/emptydir/ $BackupTo/removed/$Today/
for dir in `ls $BackupTo`
do
        if [ `echo $dir | grep -P '^vs.*.img$' | wc -l` -eq 1 ]; then
                if [ `zfs list -H -o name | grep ${dir%.img} | wc -l` -eq 0 ]; then
                        mv $BackupTo/$dir $BackupTo/removed/$Today/
                        mv $BackupTo/${dir%.img} $BackupTo/removed/$Today/
                fi
        fi
	vol=`echo $dir | perl -e 'while(<>){if(/-(\S+)_snapshot/) {print $1."\n";}}' | sed 's/--/-/g'`
	if [ -z "$vol" ]; then
		continue
	fi
	if [ `zfs list -H -o name | grep $vol | wc -l` -eq 0 ]; then
		mv $BackupTo/$dir $BackupTo/removed/$Today/
		mv $BackupTo/${vol}.img $BackupTo/removed/$Today/
	fi
done

$Cpuwatch $Avg nice --adjustment=+15 /usr/bin/rsync --delete -a $HomeDir/emptydir/ $BackupTo/$Today/
$Cpuwatch $Avg nice --adjustment=+15 /usr/bin/rsync --exclude-from=$HomeDir/exclude.list $Opts/$Today/ / $BackupTo/mirror/

backup()
{
	uuid=`/bin/cat /proc/sys/kernel/random/uuid`
	echo $uuid > $BackupTo/uuid
	if [ "$uuid" != "`/bin/cat $BackupTo/uuid`" ]; then
		echo "Can't write to $DeviceName [`date '+%F %T'`]" >> $Log
		echo "LV: $1, Day - $Today" | mail -s "Can't write to $DeviceName on `hostname` [`date '+%F %T'`]" $Mail
		exit
	fi
	uuid=`/bin/cat /proc/sys/kernel/random/uuid`
	echo $uuid > $BackupTo/$1/mirror/uuid
	if [ "$uuid" != "`/bin/cat $BackupTo/$1/mirror/uuid`" ]; then
		echo "Can't write to $BackupTo/$1/mirror [`date '+%F %T'`]" >> $Log
		echo "LV: $1, Day - $Today" | mail -s "Can't write to $BackupTo/$1/mirror on `hostname` [`date '+%F %T'`]" $Mail
		return 2
	fi
	rm -f $BackupTo/$1/mirror/uuid
	if [[ `date +%k` -ge ${BwLimit[1]} && `date +%k` -lt ${BwLimit[2]} ]]; then
		limit=${BwLimit[3]}
	else
		limit=${BwLimit[0]}
	fi
	echo "$1" > $TmpDir/current.tmp
	echo $Today `date '+%Y%m%d'` >> $BackupTo/$1/$Status
	$Cpuwatch $Avg nice --adjustment=+15 /usr/bin/rsync --delete -a $HomeDir/emptydir/ $BackupTo/$1/$Today/
	$Cpuwatch $Avg nice --adjustment=+15 /usr/bin/rsync --bwlimit=$limit --exclude=tmp --inplace $Opts/$1/$Today/ $HomeDir/mnt/ $BackupTo/$1/mirror/
	/usr/bin/rsync -dlptgoD $HomeDir/mnt/tmp $BackupTo/$1/mirror/
}

for vol in `zfs list -H -o name -t volume | grep -v 'snapshot'`
do
	lv=`basename $vol`
	lvsync=false
	lvgzip=false
	if [ `cat $HomeDir/TheEnd.tmp | wc -l` -gt 0 ]; then
        	break
	fi
	if [ `df -P | grep $MountPoint$ | awk '{print $5}' | tr -d '%'` -ge $FreeBackup ]; then
		echo `df -h` | mail -s "Backup disk on `hostname` is full [`date '+%F %T'`]" $Mail
		exit
        fi
	if [ `grep $lv $HomeDir/exclude.list.lv | wc -l` -ge 1 ]; then
		continue
	fi
	if [ -e /dev/zvol/${vol}_snapshot ] || [ `zfs list -H -o name -t snapshot | grep $lv | grep '@snapshot' | wc -l` -gt 0 ]; then
		message=$message"
"$lv" cannot remove snapshot (DONT BACKUP)"
		continue
	fi
	if [ `grep ${lv} $HomeDir/gzip.lst | wc -l` -eq 1 ]; then
       		lvgzip=true
	fi
	zfs set refreservation=none $vol
	zfs snapshot $vol@snapshot
	zfs clone $vol@snapshot ${vol}_snapshot
	j=0
	while [ $j -lt 3600 ] && [ ! -e /dev/zvol/${vol}_snapshot ]
	do
		let "j = $j + 10"
		sleep 10
	done
	if [ ! -e /dev/zvol/${vol}_snapshot ]; then
                message=$message"
"$lv" cannot create snapshot (DONT BACKUP)"
                continue
        fi
	if [ `file -sL /dev/zvol/${vol}_snapshot | grep FAT | wc -l` -ge 1 ]; then
		lvgzip=true
	else
		if [ ! -e $BackupTo/${lv}.img ]; then
			lvsync=true
		else
			kpartx -a /dev/zvol/${vol}_snapshot
			kpartx -a $BackupTo/${lv}.img
			sleep 30
			for lvmap in `kpartx -l /dev/zvol/${vol}_snapshot | awk '{print $1}'`
			do
				if [ ! -e /dev/mapper/$lvmap ]; then
					message=$message"
"$lv" device map not found (lvsync)"
					lvsync=true
					break
				fi
				if [ `blkid -o value -s TYPE /dev/mapper/$lvmap | grep 'swap' | wc -l` -ge 1 ]; then
                                        continue
                                fi
				if [ `blkid -o value -s TYPE /dev/mapper/$lvmap | grep 'ntfs' | wc -l` -ge 1 ]; then
					lvgzip=true
                                        break
                                fi
				if [ `blkid -o value -s TYPE /dev/mapper/$lvmap | grep 'ext2\|ext3\|ext4\|xfs' | wc -l` -ge 1 ]; then
					echo "backup $lvmap"
					lvmapmirror=$(kpartx -l $BackupTo/${lv}.img | grep "`kpartx -l /dev/zvol/${vol}_snapshot | grep $lvmap | awk '{print $3, $4}'`" | head -n 1 | awk '{print $1}')
					if [ -z "$lvmapmirror" ]; then
						lvsync=true
						break
					else
						mkdir -p $BackupTo/${lvmap}/mirror
						mount /dev/mapper/$lvmapmirror $BackupTo/${lvmap}/mirror
       	        				mount -o ro /dev/mapper/${lvmap} $HomeDir/mnt
						if [ `ls $HomeDir/mnt | wc -l` -eq 0 ]; then
							message=$message"
"$lv" empty (lvsync)"
							lvsync=true
						fi
						if [ `ls $BackupTo/${lvmap}/mirror | wc -l` -eq 0 ]; then
							lvsync=true
						fi
						if [ `df -P | grep /dev/mapper/${lvmap} | awk '{print $5}' | tr -d '%'` -ge $Free ]; then
                                                        lvsync=true
                                                        echo $lv" is full" | mail -s "Partition is full on `hostname` [`date '+%F %T'`]" $Mail
                                                fi
                                                if [ `df -i -P | grep /dev/mapper/${lvmap} | awk '{print $5}' | tr -d '%'` -ge $FreeInode ]; then
                                                        lvsync=true
                                                        echo $lv" inodes is full" | mail -s "Partition is full on `hostname` [`date '+%F %T'`]" $Mail
                                                fi
                                                if [ "$lvsync" = false ] && [ "$lvgzip" = false ]; then
							backup ${lvmap}
						fi
						if [ `df -P | grep /dev/mapper/$lvmapmirror | awk '{print $5}' | tr -d '%'` -ge $Free ] || [ `df -i -P | grep /dev/mapper/$lvmapmirror | awk '{print $5}' | tr -d '%'` -ge $FreeInode ]; then
                                                        lvsync=true
                                                fi
						sleep 30
						umount $HomeDir/mnt
						umount $BackupTo/${lvmap}/mirror
						sleep 10
					fi
				else
					if [ `sfdisk -l /dev/zvol/${vol}_snapshot 2>/dev/null | grep Extended | grep $(echo $lvmap | grep -o "_snapshot[[:digit:]]") | wc -l` -eq 1 ]; then
                                        	echo "$lvmap is extended partition"
	                                        continue
        	                        else
                	                        lvsync=true
						message=$message"
"$lv" has unknown filesystem (lvsync)"
                                	        break
	                                fi
				fi
			done
			kpartx -d /dev/zvol/${vol}_snapshot
			kpartx -d $BackupTo/${lv}.img
			sleep 10
			if [ "$lvsync" = true ]; then
				$Cpuwatch $Avg nice --adjustment=+15 gzip -c $BackupTo/${lv}.img > $BackupTo/removed/$Today/${lv}.img.gz
			fi
		fi
	fi
	if [ "$lvsync" = true ] || [ "$lvgzip" = true ]; then
		$Cpuwatch $Avg nice --adjustment=+15 dd if=/dev/zvol/${vol}_snapshot of=$BackupTo/${lv}.img bs=1M
		if [ ! -e $BackupTo/${lv}.img ] || [ `stat -c %s $BackupTo/${lv}.img` -lt 1024 ]; then
                        message=$message"
"$lv" image is empty (DONT BACKUP)"
                fi

        fi
        if [ "$lvgzip" = true ]; then
                mkdir -p $BackupTo/${lv}/$Today
                $Cpuwatch $Avg nice --adjustment=+15 gzip -c $BackupTo/${lv}.img > $BackupTo/${lv}/$Today/${lv}.img.gz &
#		if [ ! -e $BackupTo/${lv}/$Today/${lv}.img.gz ] || [ `stat -c %s $BackupTo/${lv}/$Today/${lv}.img.gz` -lt 1024 ]; then
#                        message=$message"
#"$lv" image is empty (DONT BACKUP)"
#               fi
        fi
	sleep 10
	zfs destroy ${vol}_snapshot
	zfs destroy $vol@snapshot
done

if [ -n "$message" ]; then
	echo "Can't backup on `hostname`, Day - $Today 
$message" | mail -s "Can't backup on `hostname` [`date '+%F %T'`]" $Mail
fi

d2=`date`
echo "-------------END $d2----------------------" >> $Log
date_end=`date '+%F %T'`
echo "$date_begin" > $LocalStatus
echo "$date_end" >> $LocalStatus
echo "$Today" >> $LocalStatus
scp -i $HomeDir/.ssh/rstats $LocalStatus serverstats@91.239.235.70:/home/backup_stats/local/`hostname`
rm -f $LocalStatus
rm -f $TmpDir/current.tmp
rm -f $HomeDir/TheEnd.tmp
rm -f $PID
